clear all
close all
clc

DELTA_P = [0 50 100 150 200 250 300]*1e5;
etaV_e = [0.99 0.9727 0.9645 0.9570 0.9498 0.9410 0.9358];
etaV_c = [0.995 0.9687 0.9453 0.9224 0.8997 0.8772 0.8532];

MU1 = 36.5e-3; 
om = 1000 *2*pi/60;
X1 = (MU1*om)./DELTA_P;

DELTA_P2 = [50, 100, 150 200]*1e5;MU2 = 34e-3; 
om2 = [920, 1500, 2000]*2*pi/60;
Qout2 = [28.94, 28.23, 27.52, 26.57;... %@920 rpm
         47.7, 46.5, 45, 44.1;...       %@1500 rpm
         64.3, 62.72, 62.1, 61.3];      %@2000 rpm (tutto in lpm)

for ii = 1:3
    for jj = 1:4
        X2(ii, jj) = (MU2*om2(ii))./DELTA_P2(jj);
        etaV_2(ii, jj) = Qout2(ii, jj)./(33e-3*om2(ii)*60/(2*pi));
    end
end

DELTA_P3 = [10 50 100 150 200 250]*1e5; %dati pompa rundo
om3 = 1000*2*pi/60;
MU3 = [27.6 27.7 26.0 23.4 22.1 22.5]*1e-3;
etaV_3 = [0.983 0.949 0.905 0.871 0.857 0.860];
X3 = (MU3).*om3./DELTA_P3;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Fun = @(c,xdata) 1 - c(1)*xdata*1e-5 ;
coeff  = lsqcurvefit(Fun, 0 , DELTA_P, etaV_c);
figure(3)
plot(DELTA_P*1e-5, etaV_c, 'ok', [0, DELTA_P]*1e-5, Fun(coeff, [0, DELTA_P]), '-r', 'LineWidth', 1.25 )
xlim([0, DELTA_P(end)*1e-5])
ylim([0.7, 1])
xlabel('\Delta p [bar]')
ylabel('\eta_{vol}')
legend( 'Centered rotors output', ['Linear interpolation : \eta_{vol} = 1 - ' num2str(coeff*1e4) 'e-04 \Delta p'])
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

X = linspace(0.0, max(max(X1(2:end)), max(max(X2))), 100 );
etaV_exp = 1 - (6.8e-9)*(1./X) - (2.0e-5).*(1./X).^0.5;

figure(1)
plot(X, etaV_exp, '-k', X1, etaV_e, 'ob', X1, etaV_c, 'or', ...
        X3, etaV_3, '*m',  X2, etaV_2, '*c', 'LineWidth', 1.25)
xlim([0, max(X)])
ylim([0.5, 1])
legend( 'Experimental fit', 'Eccentric rotors', 'Centered rotors', ...
          'Pump 2', 'Pump 3' )
annotation('textbox', [.3, .15, .1, .1],'String', '\eta_{vol} =  1 - 6.8e-09(\Deltap/(\mu\omega)) - 2.0e-05(\Deltap/(\mu\omega))^{0.5}' ,'FitBoxToText','on');
xlabel('\mu \omega / \Delta p')
ylabel('\eta_{vol}')

FUN = @(c, xdata) 1 - c(1).*xdata.^(-1) - c(2).*xdata.^(-0.5) ;
X1 = X1(2:end); etaV_e = etaV_e(2:end); etaV_c = etaV_c(2:end);
coeff_e = lsqcurvefit(FUN, [0, 0], X1, etaV_e);
coeff_c = lsqcurvefit(FUN, [0, 0], X1, etaV_c);
coeff_3 = lsqcurvefit(FUN, [0, 0], X3, etaV_3);
coeff_2 = lsqcurvefit(FUN, [0, 0], X2, etaV_2);

figure(2)
plot(X, etaV_exp, ':k', ...
     X1, etaV_e, 'ob', X, FUN(coeff_e, X), '-b',...
     X1, etaV_c, 'or', X, FUN(coeff_c, X), '-r',...
     X3, etaV_3, '*m', X, FUN(coeff_3, X), '-m',...
     X, FUN(coeff_2, X), '-c',  X2, etaV_2, '*c', 'LineWidth', 1.25 )
xlim([0, max(X)])
ylim([0.5, 1])

annotation('textbox', [.25, .15, .1, .1],'String', ...
           ['\eta_{vol} =  1 - 6.8e-09(\Deltap/(\mu\omega)) - 2.0e-05(\Deltap/(\mu\omega))^{0.5}'] , ...
           'FitBoxToText','on');
annotation('textbox', [.25, .15, .1, .2],'String', ...
           ['\eta_{vol} =  1 - 4.34e-10(\Deltap/(\mu\omega)) - 2.15e-05(\Deltap/(\mu\omega))^{0.5}'] , ...
           'FitBoxToText','on', 'Color', 'b');
annotation('textbox', [.25, .15, .1, .3],'String', ...
           ['\eta_{vol} =  1 - 1.54e-08(\Deltap/(\mu\omega)) - 8.91e-06(\Deltap/(\mu\omega))^{0.5}'] , ...
           'FitBoxToText','on', 'Color', 'r');
annotation('textbox', [.25, .15, .1, .4],'String', ...
           ['\eta_{vol} =  1 + 1.78e-10(\Deltap/(\mu\omega)) - 4.72e-05(\Deltap/(\mu\omega))^{0.5}'] , ...
           'FitBoxToText','on', 'Color', 'm');
annotation('textbox', [.25, .15, .1, .5],'String', ...
           ['\eta_{vol} =  1 - 8.21e-09(\Deltap/(\mu\omega)) - 3.11e-05(\Deltap/(\mu\omega))^{0.5}'] , ...
           'FitBoxToText','on', 'Color', 'c');

xlabel('\mu \omega / \Delta p')
ylabel('\eta_{vol}')












